# Note: немного об известных леммерах
# 1. yandex_lemmer (bindings/python/lemmer_lib) – не поддерживает python 3
# 2. clemmer (ads/clemmer/python) – не собирается локально на macos
# 3. yabs_clemmer (ads/libs/py_lemmer) – работает с байтами, а не строками

from itertools import chain

import yabs_clemmer as clemmer

from intranet.search.core.query.ast import Text, OrderedText


def _bulk_analyze(values, lang):
    return chain.from_iterable(
        clemmer.analyze2(value.encode('utf-8'), lang)
        for value in values
    )


def get_lemmas(values, lang=clemmer.LANG_RUS):
    """
    Отдаёт множество возможных лемм (начальных форм) для слов `values`
    """
    words = _bulk_analyze(values, lang)
    lemmas = chain.from_iterable(i.lemmas for i in words)
    return {i.decode('utf-8') for i in lemmas}


def generate_word_forms(value, lang=clemmer.LANG_RUS):
    """
    Отдаёт множество всех возможных форм слова
    """
    lemmas = get_lemmas([value], lang)
    words = _bulk_analyze(lemmas, lang)
    forms = chain.from_iterable(i.formas for i in words)
    return {i.decode('utf-8') for i in forms}


def generate_query_word_forms(query):
    # генерируем все возможные словоформы запроса
    generated = set()

    for node in query.filter_text_nodes():
        if isinstance(node, OrderedText):
            generated.add(node.text)
        elif isinstance(node, Text):
            generated.add(node.text)
            for lang in [clemmer.LANG_RUS, clemmer.LANG_ENG]:
                generated.update(generate_word_forms(node.text, lang))
        else:
            raise ValueError('Unsupported node type for node %s' % node)

    return sorted(generated, key=len, reverse=True)
