import os
import urllib
from svn.remote import RemoteClient
from svn.constants import LT_URL


class IsearchSvnClient(RemoteClient):
    def __init__(self, url, *args, **kwargs):
        super().__init__(url, LT_URL, *args, **kwargs)

    def filter_recursive(self, rel_path=None, pattern=None, files_only=False):
        full_url_or_path = self.url

        if rel_path:
            full_url_or_path = urllib.parse.urljoin(self.url, rel_path)

        args = ['--recursive']
        if pattern:
            args.extend(['--search', pattern])
        args.append(full_url_or_path)

        for line in self.run_command('ls', args, do_combine=False):
            line.strip()
            # Директории в листинге оканчиваются на '/'
            if files_only and line.endswith(os.path.sep):
                continue
            # Команда иногда возвращает варнинги, отфильтровываем их
            if line.startswith('Warning:'):
                continue
            yield line
