import re
from wtforms.validators import URL


class MaybeSchemalessURL(URL):
    def __init__(self, require_tld=True, message=None):
        super().__init__(require_tld=require_tld, message=message)
        self.regex = re.compile(
            r"(?P<schema>^[a-z]+://)?"
            r"(?P<host>[^\/\?:]+)"
            r"(?P<port>:[0-9]+)?"
            r"(?P<path>\/.*?)?"
            r"(?P<query>\?.*)?$"
        )
