import yt.wrapper as yt
from yt import yson

from django.conf import settings

from intranet.search.core.utils import get_oauth_token

yt_opts = settings.ISEARCH['yt']
yt_proxy = settings.ISEARCH_YT_PROXY or yt_opts['proxy']

yt.config.set_proxy(yt_proxy)
yt.config['token'] = get_oauth_token(yt_opts['token'])

client = yt.YtClient(proxy=yt_proxy, token=get_oauth_token(yt_opts['token']),
                     config=yt_opts.get('spec', {}))


def convert_static_to_dynamic_table(path, schema, key_columns):
    sort_table(path, schema, key_columns)
    yt.alter_table(path, dynamic=True)
    client.set(f"{path}/@tablet_cell_bundles", yt_opts['bundle'])
    client.mount_table(path, sync=True)


def sort_table(table, schema, key_columns):
    sorted_schema = yson.YsonList(schema)
    sorted_schema[0]['sort_order'] = 'ascending'
    sorted_schema.attributes['unique_keys'] = True
    client.run_sort(
        table,
        yt.TablePath(str(table), attributes={'schema': sorted_schema}),
        sort_by=key_columns,
        sync=True,
        spec={
            "partition_job_io": {"table_writer": {"block_size": 256 * 2 ** 10}},
            "merge_job_io": {"table_writer": {"block_size": 256 * 2 ** 10}},
            "sort_job_io": {"table_writer": {"block_size": 256 * 2 ** 10}}
        }
    )
    sorted_schema[0].pop('sort_order')


def create_dynamic_yt_table(path, schema):
    yt.create('table', path, recursive=True,
              attributes={'schema': schema, 'dynamic': True})
    client.set(f"{path}/@tablet_cell_bundles", yt_opts['bundle'])
    client.mount_table(path, sync=True)


def create_table_and_insert_rows(yt_table, rows, schema):
    try:
        client.insert_rows(yt_table, rows)
    except yt.YtHttpResponseError as e:
        if e.contains_text('has no child with key'):
            create_dynamic_yt_table(yt_table, schema)
            client.insert_rows(yt_table, rows)
        else:
            raise


def delete_rows(yt_table, rows):
    client.delete_rows(yt_table, rows)
