import libra
from collections import defaultdict, Counter
from urllib.parse import unquote
from libra_parse_utils import Row, get_query_data, is_intrasearch, shrink_dwell_time


def parse_clicks(blockstat_path, utils_path='', include_suggest=False):
    def libra_callable(uid, recs):
        session = libra.ParseSessionWithFat(recs, blockstat_path)
        for request in session:
            if not is_intrasearch(request):
                continue

            data = get_query_data(request)
            if not data or not data['scope'] or data['scope'] == 'suggest' and not include_suggest:
                continue

            clicks = defaultdict(Counter)
            for number, click in enumerate(request.GetClicks()):
                clicks[unquote(click.Url)]['dwell_time'] += click.DwellTime or 0

            for block in request.GetMainBlocks():
                for ch in block.GetChildren():
                    click = clicks.get(ch.Url) or {}
                    yield Row(
                        uid=uid,
                        intrasearch_reqid=data['reqid'],
                        scope=data['scope'],
                        zone=data['zone'],
                        wizard_name=data['wizard_name'],
                        text=request.Query,
                        url=ch.Url,
                        dwell_time=shrink_dwell_time(click.get('dwell_time')),
                    )

    return libra_callable
