PRAGMA DisableAnsiRankForNullableKeys;

$cut = ($value) -> {
    return IF($value > 1, 1.0, IF($value < 0, 0.0, $value))
};

insert into {{output1}}
select
    query,
    url, 
    $cut(
        COUNT_IF(score = 'vital') * 0.25
        +
        COUNT_IF(score = 'relevant') * 0.1
        +  
        COUNT_IF(score = 'irrelevant') * -0.25
        +
        Math::Log2(IF(COUNT_IF(dwell_time > 60) > 1, COUNT_IF(dwell_time > 60), 1)))
    AS rating,
    SOME(factors) as factors
from {{input1}}
group by
    String::AsciiToLower(query) as query, 
    url;
