import logging

import sandbox.sdk2 as sdk2
import intranet.search.sandbox.updateAchievery.update_achievery as management


class UpdateAchievery(sdk2.Task):
    """
    Task to schedule the automatic update of achievement 1292
    """

    class Parameters(sdk2.Parameters):
        tokens = sdk2.parameters.YavSecret(
            "OAuth token for task to access Staff/Achievery API",
            default="sec-01fs9t41k7aexett662q5z1v91",
        )
        table_path = sdk2.parameters.String(
            "Path to marks_with_uids table in YT within cluster",
            multiline=False,
            default="//home/intrasearch/output/production/marks_with_uids",
        )
        api_url = sdk2.parameters.String(
            "Base URL to access Achievery API",
            multiline=False,
            default="https://staff.yandex-team.ru/api/achievery/",
        )
        proxy = sdk2.parameters.String(
            "Cluster with required table",
            multiline=False,
            default="hahn",
        )
        staff_api_url = sdk2.parameters.String(
            "URL to access staff-api/persons",
            multiline=False,
            default="https://staff-api.yandex-team.ru/v3/persons",
        )
        timeout = sdk2.parameters.Integer(
            "Timeout for staff requests (in seconds)",
            default=10,
        )
        is_dry_run = sdk2.parameters.Bool(
            "If set to True, then only logs will be collected, and no actual achievement edits will be done",
            default=False,
        )

    def on_execute(self):
        tokens = self.Parameters.tokens.data()
        timeout = self.Parameters.timeout
        is_dry_run = self.Parameters.is_dry_run
        oauth = tokens["intrasearch_oauth_common"]
        yt = tokens["intrasearch_oauth_yt"]
        try:
            obj = management.IntrasearchAchieveryManager(
                token=oauth,
                yt_token=yt,
                table_with_marks=self.Parameters.table_path,
                api_url=self.Parameters.api_url,
                proxy=self.Parameters.proxy,
                staff_api_url=self.Parameters.staff_api_url,
                timeout=timeout,
                is_dry_run=is_dry_run,
            )
            obj.handle()
        except Exception as err:
            logging.error(f"Error occurred: {err}")
            raise
