import os

from intranet.search.settings.app_settings import APP_NAME

global_module = __import__('intranet.search.settings.celery.global_config.%s' % APP_NAME, {}, {}, [''])

for name in dir(global_module):
    if name.upper() == name:
        locals()[name] = getattr(global_module, name)


CELERYBEAT_SCHEDULE = locals()['CELERYBEAT_SCHEDULE']


if not int(os.environ.get('ENABLE_REINDEX', 0)):
    keys = [key for key in CELERYBEAT_SCHEDULE if key.startswith('reindex-')]
    for key in keys:
        CELERYBEAT_SCHEDULE.pop(key)


if not int(os.environ.get('ENABLE_LISTENERS', 0)):
    CELERYBEAT_SCHEDULE.pop('listen_tracker', None)


if not int(os.environ.get('ENABLE_YT_TASKS', 0)):
    keys = [key for key in CELERYBEAT_SCHEDULE if key.startswith('yt_')]
    for key in keys:
        CELERYBEAT_SCHEDULE.pop(key)

if not int(os.environ.get('ENABLE_YQL_TASKS', 0)):
    keys = [key for key in CELERYBEAT_SCHEDULE if key.startswith('yql_')]
    for key in keys:
        CELERYBEAT_SCHEDULE.pop(key)

if not int(os.environ.get('ENABLE_BASIC_TASKS', 0)):
    keys = ['run_check', 'clear_pushes', 'update_pushes', 'restart_pushes', 'clear_indexations']
    for key in keys:
        CELERYBEAT_SCHEDULE.pop(key)

if os.environ.get('ENABLE_SEARCHES_REINDEXING', '').strip():
    enabled_searches = set(os.environ.get('ENABLE_SEARCHES_REINDEXING', '').strip().split(','))
    keys = [key for key in CELERYBEAT_SCHEDULE if key.startswith('reindex-')]
    for key in keys:
        item = CELERYBEAT_SCHEDULE.get(key)
        if item is not None:
            search_name = item['args'][1]
            if search_name not in enabled_searches:
                CELERYBEAT_SCHEDULE.pop(key, None)

if os.environ.get('DISABLE_SEARCHES_REINDEXING', '').strip():
    disabled_searches = set(os.environ.get('DISABLE_SEARCHES_REINDEXING', '').strip().split(','))
    keys = [key for key in CELERYBEAT_SCHEDULE if key.startswith('reindex-')]
    for key in keys:
        item = CELERYBEAT_SCHEDULE.get(key)
        if item is not None:
            search_name = item['args'][1]
            if search_name in disabled_searches:
                CELERYBEAT_SCHEDULE.pop(key, None)
