import os
import json
from datetime import timedelta

import datasources_config_wrapper
from celery.schedules import crontab

from intranet.search.settings.app_settings import APP_NAME, ISEARCH  # noqa

conf = datasources_config_wrapper.DatasourcesConfigWrapper(prefix='intrasearch',
                                                           suppress_warning=True,
                                                           fallback_on_env_vars=True)

IN_DEPLOY = 'DEPLOY_BOX_ID' in os.environ
if IN_DEPLOY:
    mongo_db3_hosts_list = json.loads(conf.mongo_db3_hosts_list)
else:
    mongo_db3_hosts_list = conf.mongo_db3_hosts_list

BROKER_URL = 'mongodb://{hosts}/{dbname}?replicaSet={rs}'.format(
    hosts=','.join(mongo_db3_hosts_list or []),
    dbname=conf.mongo_db3_dbname,
    rs=conf.mongo_db3_rs,
)
BROKER_USER = conf.mongo_db3_user
BROKER_PASSWORD = conf.mongo_db3_password

CELERY_IMPORTS = ['intranet.search.core.tasks']

CELERY_RESULT_BACKEND = 'mongodb'

CELERY_MONGODB_BACKEND_SETTINGS = {
    'host': BROKER_URL,
    'database': conf.mongo_db3_dbname,
}

CELERY_EAGER_PROPAGATES_EXCEPTIONS = True

CELERY_ACKS_LATE = True

CELERYD_FORCE_EXECV = True

CELERY_MESSAGE_COMPRESSION = 'gzip'

CELERYD_HIJACK_ROOT_LOGGER = False

CELERY_TIMEZONE = 'Europe/Moscow'

CELERYD_PREFETCH_MULTIPLIER = 4

CELERY_TASK_SERIALIZER = 'pickle'

BROKER_TRANSPORT_OPTIONS = {}

CELERY_EVENT_QUEUE_TTL = 30

CELERY_EVENT_QUEUE_EXPIRES = 60 * 16

CELERY_EVENT_SERIALIZER = 'pickle'

CELERY_IGNORE_RESULT = True

CELERY_TASK_RESULT_EXPIRES = 60

CELERY_WORKER_DIRECT = True

CELERY_ACCEPT_CONTENT = ['pickle', 'json', 'msgpack', 'yaml']

CELERY_CREATE_MISSING_QUEUES = True

import warnings

warnings.filterwarnings('ignore', category=UserWarning, module=r'^pymongo\.mongo_client$')

# FIXME перенести это в обычные настройки или вообще тупо в indexer
ISEARCH_LOCAL_QUEUE_TMPLT = 'default@%s.dq'

CELERY_ROUTES = {
    'isearch.tasks.management': {'queue': 'management'},
    'isearch.tasks.run_check': {'queue': 'management'},
    'isearch.tasks.listen_tracker': {'queue': 'management'},
    'isearch.tasks.listen_docs': {'queue': 'management'},
    'isearch.tasks.clear_pushes': {'queue': 'management'},
    'isearch.tasks.update_pushes': {'queue': 'management'},
    'isearch.tasks.restart_pushes': {'queue': 'management'},

    # в локальном app
    'isearch.tasks.collect_stats': {'queue': 'management'},
    'isearch.tasks.collect_indexation_stats': {'queue': 'management'},
    'isearch.tasks.heartbeat': {'queue': 'management'},
    'isearch.tasks.delete_finished_stats': {'queue': 'management'},
    'isearch.tasks.flush_buffered_attributes': {'queue': 'management'},
}

reindex_comment = 'Scheduled reindexing'

# Общие для bisearch и isearch регулярные таски
CELERYBEAT_SCHEDULE = {
    'run_check': {
        'task': 'isearch.tasks.run_check',
        'schedule': timedelta(seconds=30),
        'kwargs': {
            'seconds': 60,
        },
    },
    'listen_tracker': {
        'task': 'isearch.tasks.listen_tracker',
        'schedule': crontab(),
    },
    'listen_docs': {
        'task': 'isearch.tasks.listen_docs',
        'schedule': crontab(),
    },
    'clear_pushes': {
        'task': 'isearch.tasks.clear_pushes',
        'schedule': crontab(minute='0', hour='*/6'),
        'kwargs': {
            'days': ISEARCH['indexations']['clear_pushes_threshold'],
        },
    },
    'update_pushes': {
        'task': 'isearch.tasks.update_pushes',
        'schedule': timedelta(seconds=30),
    },
    'restart_pushes': {
        'task': 'isearch.tasks.restart_pushes',
        'schedule': timedelta(minutes=10),
    },
    'clear_indexations': {
        'task': 'isearch.tasks.clear_indexations',
        'schedule': crontab(minute='10', hour='2'),
        'kwargs': {
            'days': ISEARCH['indexations']['clear_indexations_threshold'],
        },
    },
}
