from intranet.search.settings.celery.defaults import *  # noqa: ImportStarUsed


BISEARCH_CELERYBEAT_SCHEDULE = {
    'reindex-wiki': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='25,55'),  # noqa: ImportStarUsage
        'args': ('reindex_wiki', 'wiki'),
        'kwargs': {
            '_lock': True,
            'index': 'bisearch',
            'lock_timeout': '1h',
            'use_ts': True,
            'comment': reindex_comment,  # noqa: ImportStarUsage
            'load_percent': 50,
            'reindex_delta': '2h',
        },
    },
}

CELERYBEAT_SCHEDULE.update(BISEARCH_CELERYBEAT_SCHEDULE)  # noqa: ImportStarUsage
