from datetime import timedelta  # noqa
from celery.schedules import crontab

from intranet.search.settings.celery.defaults import reindex_comment, CELERYBEAT_SCHEDULE  # noqa
from intranet.search.settings.celery.defaults import *  # noqa


ISEARCH_CELERYBEAT_SCHEDULE = {
    'reindex-equipment': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='1', hour='9'),
        'args': ('reindex', 'equipment',),
        'kwargs': {
            'comment': reindex_comment,
        },
    },
    'reindex-people': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='45'),
        'args': ('reindex', 'people',),
        'kwargs': {
            '_env': ['production'],
            'comment': reindex_comment,
            'lock_timeout': '5m',
        },
    },
    'reindex-people-delta': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='*/10'),
        'args': ('reindex', 'people',),
        'kwargs': {
            'comment': reindex_comment + ' delta',
            'lock_timeout': '5m',
            'use_ts': True,
            'priority': 3,
        },
    },
    'reindex-groups': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(hour='*/2', minute='53'),
        'args': ('reindex', 'people',),
        'kwargs': {
            'index': 'groups',
            'comment': reindex_comment,
            'lock_timeout': '5h',
        },
    },
    'reindex-wiki': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='25', hour='8-23'),
        'args': ('reindex', 'wiki',),
        'kwargs': {
            'use_ts': True,
            'comment': reindex_comment,
            'document_storages': 'logbroker',
            'lock_timeout': '5h',
            'suffix': 'at',
        },
    },
    'reindex-wiki-clicked-marked-delta': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='55', hour='23'),
        'args': ('reindex', 'wiki',),
        'kwargs': {
            '_env': ['production'],
            'clicked_marked_urls': True,
            'comment': reindex_comment + ' clicked marked delta',
            'document_storages': 'logbroker',
            'suffix': 'at',
        },
    },
    'reindex-invite': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='1', hour='10'),
        'args': ('reindex', 'invite',),
        'kwargs': {
            'comment': reindex_comment,
        },
    },
    'reindex-mldescription': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='10', hour='10'),
        'args': ('reindex', 'mldescription',),
        'kwargs': {
            'comment': reindex_comment,
        },
    },
    'reindex-services': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='*/15'),
        'args': ('reindex', 'plan',),
        'kwargs': {
            '_env': ['production'],
            'index': 'services',
            'comment': reindex_comment,
        },
    },
    'reindex-suggest': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(hour='*/2', minute='50'),
        'args': ('reindex', 'plan',),
        'kwargs': {
            '_env': ['production'],
            'index': 'suggest',
            'comment': reindex_comment,
            'lock_timeout': '5h',
        },
    },
    'reindex-doc': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='40', hour='5'),
        'args': ('reindex', 'doc',),
        'kwargs': {
            'comment': reindex_comment,
            'revision_ttl': '14d',
            'shadow_revision': True,
        },
    },
    'reindex-doc-external': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='40'),
        'args': ('reindex', 'doc',),
        'kwargs': {
            'index': 'external',
            'comment': reindex_comment,
            'revision_ttl': '14d',
            'lock_timeout': '5h',
            'shadow_revision': True,
        },
    },
    'reindex-doc-readme': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='25', hour='*/4'),
        'args': ('reindex', 'doc',),
        'kwargs': {
            '_env': ['production'],
            'index': 'readme',
            'comment': reindex_comment,
            'revision_ttl': '14d',
            'lock_timeout': '5h',
        },
    },
    'reindex-at-clubs': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='50', hour='12'),
        'args': ('reindex', 'at',),
        'kwargs': {
            '_env': ['production'],
            'index': 'clubs',
            'comment': reindex_comment,
            'suffix': 'at',
            'document_storages': 'logbroker',
        },
    },
    # ISEARCH-5346 отключаем индексацию лего, пока они не начнут держать нагрузку
    # 'reindex-lego': {
    #     'task': 'isearch.tasks.management',
    #     'schedule': crontab(minute='7', hour='8', day_of_week=3),
    #     'args': ('reindex', 'lego',),
    #     'kwargs': {
    #         'nort': True,
    #         'comment': reindex_comment,
    #         'index': 'lego',
    #         'suffix': 'at'
    #     },
    # },
    'reindex-beminfo': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='1', hour='14', day_of_week=3),
        'args': ('reindex', 'lego',),
        'kwargs': {
            '_env': ['production'],
            'nort': True,
            'comment': reindex_comment,
            'index': 'beminfo',
        },
    },
    'reindex-femida-candidates': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='0', hour='2'),
        'args': ('reindex', 'femida'),
        'kwargs': {
            '_env': ['production'],
            'index': 'candidates',
            'comment': reindex_comment,
        },
    },
    'reindex-goals': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(hour='*/2', minute='20'),
        'args': ('reindex', 'goals',),
        'kwargs': {
            '_env': ['production'],
            'comment': reindex_comment,
            'lock_timeout': '5h',
        },
    },
    'reindex-idm-groups-delta': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(hour='*/5'),
        'args': ('reindex', 'idm'),
        'kwargs': {
            'index': 'groups',
            'comment': reindex_comment + ' delta',
            'use_ts': True,
            'priority': 3,
            'lock_timeout': '1h',
        },
    },
    'reindex-idm-users-delta': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='10-59/15'),
        'args': ('reindex', 'idm'),
        'kwargs': {
            'index': 'users',
            'comment': reindex_comment + ' delta',
            'use_ts': True,
            'priority': 3,
            'lock_timeout': '1h',
        },
    },
    'reindex-idm-groups': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute=0, hour=23),
        'args': ('reindex', 'idm'),
        'kwargs': {
            'index': 'groups',
            'comment': reindex_comment,
        },
    },
    'reindex-idm-users': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute=23, hour=23),
        'args': ('reindex', 'idm'),
        'kwargs': {
            'index': 'users',
            'comment': reindex_comment,
        },
    },
    # disable reindexing rolenodes as no successful recent reindexing
    # 'reindex-idm-rolenodes': {
    #     'task': 'isearch.tasks.management',
    #     # индексируем дельту нод каждый час
    #     'schedule': crontab(minute='20'),
    #     'args': ('reindex', 'idm'),
    #     'kwargs': {
    #         'index': 'rolenodes',
    #         'comment': reindex_comment,
    #         'use_ts': True,
    #         'lock_timeout': '5h',
    #     },
    # },
    'reindex-conductor-tickets': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='*/20'),
        'args': ('reindex', 'conductor'),
        'kwargs': {
            '_env': ['production'],
            'index': 'tickets',
            'comment': reindex_comment,
            'use_ts': True,
            'suffix': 'conductor',
            'lock_timeout': '5h',
        },
    },
    'reindex-conductor-groups': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='*/25'),
        'args': ('reindex', 'conductor'),
        'kwargs': {
            '_env': ['production'],
            'index': 'groups',
            'comment': reindex_comment,
            'use_ts': True,
            'suffix': 'conductor',
            'lock_timeout': '5h',
        },
    },
    'reindex-conductor-hosts': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='5-59/25'),
        'args': ('reindex', 'conductor'),
        'kwargs': {
            '_env': ['production'],
            'index': 'hosts',
            'comment': reindex_comment,
            'use_ts': True,
            'suffix': 'conductor',
            'lock_timeout': '5h',
        },
    },
    'reindex-conductor-packages': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='35', hour='2'),
        'args': ('reindex', 'conductor'),
        'kwargs': {
            '_env': ['production'],
            'index': 'packages',
            'comment': reindex_comment,
            'suffix': 'conductor',
        },
    },
    'reindex-conductor-projects': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='05', hour='3'),
        'args': ('reindex', 'conductor'),
        'kwargs': {
            '_env': ['production'],
            'index': 'projects',
            'comment': reindex_comment,
            'suffix': 'conductor',
        },
    },
    'reindex-conductor-workflow_groups': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='40', hour='*/3'),
        'args': ('reindex', 'conductor'),
        'kwargs': {
            '_env': ['production'],
            'index': 'workflow_groups',
            'comment': reindex_comment,
            'suffix': 'conductor',
            'lock_timeout': '5h',
        },
    },
    'reindex-conductor-workflows': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='10', hour='*/3'),
        'args': ('reindex', 'conductor'),
        'kwargs': {
            '_env': ['production'],
            'index': 'workflows',
            'comment': reindex_comment,
            'suffix': 'conductor',
            'lock_timeout': '5h',
        },
    },
    'reindex-moebius': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute=23, hour=23),
        'args': ('reindex', 'moebius'),
        'kwargs': {
            '_env': ['testing'],
            'comment': reindex_comment,
        },
    },
    # не индексации
    'yql_calc_metrics': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(hour='15', minute='0'),
        'args': ('yql_calc_metrics',),
        'kwargs': {
            '_env': ['production'],
            '_lock': True,
            '_lock_name': 'yql_calc_metrics',
        }
    },
    'yql_calc_suggest_metrics': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(hour='15', minute='15'),
        'args': ('yql_calc_suggest_metrics',),
        'kwargs': {
            '_env': ['production'],
            '_lock': True,
            '_lock_name': 'yql_calc_suggest_metrics',
        }
    },
    'yql_update_clicked_marked_urls': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(hour='16', minute='0'),
        'args': ('yql_update_clicked_marked_urls',),
        'kwargs': {
            '_lock': True,
            '_lock_name': 'yql_update_clicked_marked_urls',
        }
    },
    'yql_calc_people_search_frequency': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(hour='16', minute='30'),
        'args': ('yql_calc_people_search_frequency',),
        'kwargs': {
            '_lock': True,
            '_lock_name': 'yql_calc_people_search_frequency',
        },
    },
    'yt_export_marks': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='5'),
        'args': ('export_marks',),
        'kwargs': {
            '_lock': True,
            '_lock_name': 'export_marks',
        }
    },
    'yt_extract_links': {
        'task': 'isearch.tasks.management',
        'schedule': crontab(minute='10', hour='2'),
        'args': ('yt', 'extract_links'),
        'kwargs': {
            '_lock': True,
            '_lock_name': 'yt_extract_links',
        },
    },
}

CELERYBEAT_SCHEDULE.update(ISEARCH_CELERYBEAT_SCHEDULE)
