from datetime import timedelta

from .defaults import *  # noqa


BROKER_URL = 'redis+socket:///var/run/yandex/intrasearch/redis/celery.sock'
BROKER_TRANSPORT_OPTIONS = {}

CELERY_WORKER_DIRECT = False

# http://celery.readthedocs.org/en/latest/changelog.html#version-3-1-17
CELERYD_FORCE_EXECV = False

# Выставляем prefetch в 32, чтобы воркеры забирали в буфер
# больше тасков. Повышает производительность
CELERYD_PREFETCH_MULTIPLIER = 32

CELERYBEAT_SCHEDULE = {
    'collect_stats': {
        'task': 'isearch.tasks.collect_stats',
        'schedule': timedelta(seconds=30),
        'options': {
            'priority': 9,
        },
    },
    'delete_finished_stats': {
        'task': 'isearch.tasks.delete_finished_stats',
        'schedule': timedelta(hours=1),
        'options': {
            'priority': 9,
        },
    },
    'flush_buffered_attributes': {
        'task': 'isearch.tasks.flush_buffered_attributes',
        'schedule': timedelta(seconds=60),
    },
    'node_heartbeat': {
        'task': 'isearch.tasks.heartbeat',
        'schedule': timedelta(seconds=10),
    },
}
