import logging.config

import yenv

from intranet.search.settings.app_settings import get_logging_config


YENV_TYPE = yenv.choose_type(['development', 'testing', 'prestable', 'production'])

env_module = __import__('intranet.search.settings.django.env.%s' % YENV_TYPE, {}, {}, [''])

for name in dir(env_module):
    if name.upper() == name:
        locals()[name] = getattr(env_module, name)


ISEARCH = locals()['ISEARCH']


LOGGING = get_logging_config(ISEARCH['logging'])
logging.config.dictConfig(LOGGING)

# дефолтные настройки хайлайтинга
HILITE_START_TAG = '@hlword@'
HILITE_END_TAG = '@/hlword@'
