import os
import logging

log = logging.getLogger(__name__)


class BaseJob:
    entity = 'default'  # название сущности

    @property
    def common_table_prefix(self):
        from django.conf import settings
        return settings.ISEARCH['yt']['base_path']

    def __init__(self, options=None):
        from intranet.search.core.yt_client import client, yt_opts
        self.yt = client
        self.yt_opts = yt_opts
        self.options = options or {}

    def _get_table_path(self, name):
        return os.path.join(self.common_table_prefix, 'output', self.options['env'],
                            self.entity, name)

    def _get_table(self, name, delete=False, **create_kwargs):
        """ Создает таблицу с именем `name` в правильном месте, или возвращает
        уже существующую
        """
        if name.startswith('//'):
            return name.rstrip('/')

        path = self._get_table_path(name)
        if delete and self.yt.exists(path):
            self.yt.remove(path)
        if not self.yt.exists(path):
            self.yt.create('table', path, recursive=True, **create_kwargs)
        return path
