"""bot_user_table

Revision ID: 0001
Revises:
Create Date: 2022-01-13 08:11:11.328343+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0001'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('bot_user',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('telegram_id', sa.String(), nullable=False),
    sa.Column('username', sa.String(), nullable=False),
    sa.Column('staff_id', sa.Integer(), nullable=True),
    sa.Column('staff_uid', sa.String(), nullable=False),
    sa.Column('staff_login', sa.String(), nullable=True),
    sa.Column('state', sa.Enum('active', 'deprived', name='botuserstate'), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('staff_uid'),
    sa.UniqueConstraint('username')
    )
    op.create_index(op.f('ix_bot_user_id'), 'bot_user', ['id'], unique=False)
    op.create_index(op.f('ix_bot_user_telegram_id'), 'bot_user', ['telegram_id'], unique=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_bot_user_telegram_id'), table_name='bot_user')
    op.drop_index(op.f('ix_bot_user_id'), table_name='bot_user')
    op.drop_table('bot_user')
    # ### end Alembic commands ###
