"""email_subscription

Revision ID: 0003
Revises: 0002
Create Date: 2022-01-28 14:08:27.953130+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '0003'
down_revision = '0002'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('email',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('address', sa.String(), nullable=False),
    sa.Column('author_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['author_id'], ['bot_user.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_email_id'), 'email', ['id'], unique=False)
    op.add_column('subscription', sa.Column('email_id', sa.Integer(), nullable=True))

    subscription_type = postgresql.ENUM('chat', 'email', name='subscriptiontype')
    subscription_type.create(op.get_bind())

    op.add_column('subscription', sa.Column('type', subscription_type, nullable=False, server_default='chat'))
    op.alter_column('subscription', 'type', server_default=None)
    op.alter_column('subscription', 'chat_id',
               existing_type=sa.INTEGER(),
               nullable=True)
    op.create_foreign_key(None, 'subscription', 'email', ['email_id'], ['id'])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'subscription', type_='foreignkey')
    op.alter_column('subscription', 'chat_id',
               existing_type=sa.INTEGER(),
               nullable=False)
    op.drop_column('subscription', 'type')

    subscription_type = postgresql.ENUM('chat', 'email', name='subscriptiontype')
    subscription_type.drop(op.get_bind())

    op.drop_column('subscription', 'email_id')
    op.drop_index(op.f('ix_email_id'), table_name='email')
    op.drop_table('email')
    # ### end Alembic commands ###
