"""add-logbroker-event

Revision ID: 0004
Revises: 0003
Create Date: 2022-02-11 13:16:52.440762+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0004'
down_revision = '0003'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('logbroker_event',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('creation_date', sa.Integer(), nullable=True),
    sa.Column('event_id', sa.Integer(), nullable=False),
    sa.Column('link', sa.String(), nullable=False),
    sa.Column('type', sa.Enum('question_posted', 'answer_posted', 'comment_posted', 'post_edited', name='logbrokereventtype'), nullable=False),
    sa.Column('state', sa.Enum('new', 'sent', name='logbrokereventstate'), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_logbroker_event_creation_date'), 'logbroker_event', ['creation_date'], unique=False)
    op.create_index(op.f('ix_logbroker_event_event_id'), 'logbroker_event', ['event_id'], unique=False)
    op.create_index(op.f('ix_logbroker_event_id'), 'logbroker_event', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_logbroker_event_id'), table_name='logbroker_event')
    op.drop_index(op.f('ix_logbroker_event_event_id'), table_name='logbroker_event')
    op.drop_index(op.f('ix_logbroker_event_creation_date'), table_name='logbroker_event')
    op.drop_table('logbroker_event')
    # ### end Alembic commands ###
