"""digest

Revision ID: 0006
Revises: 0005
Create Date: 2022-02-17 13:37:49.666348+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0006'
down_revision = '0005'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('subscription_unanswered',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('tag', sa.String(), nullable=False),
    sa.Column('type', sa.Enum('chat', 'email', name='subscriptiontypeunanswered'), nullable=False),
    sa.Column('chat_id', sa.Integer(), nullable=True),
    sa.Column('email_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['chat_id'], ['chat.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['email_id'], ['email.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_subscription_unanswered_id'), 'subscription_unanswered', ['id'], unique=False)
    op.create_index(op.f('ix_subscription_unanswered_tag'), 'subscription_unanswered', ['tag'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_subscription_unanswered_tag'), table_name='subscription_unanswered')
    op.drop_index(op.f('ix_subscription_unanswered_id'), table_name='subscription_unanswered')
    op.drop_table('subscription_unanswered')
    # ### end Alembic commands ###
