from pydantic import Field, SecretStr

from .default import Settings as DefaultSettings


class Settings(DefaultSettings):
    ENV_TYPE: str = 'development'

    CELERY_TASK_ALWAYS_EAGER: bool = True

    POSTGRES_DATABASE: str = Field('stackbot', env='PG_LOCAL_DATABASE')
    POSTGRES_USER: str = Field('postgres', env='PG_LOCAL_USER')
    POSTGRES_PASSWORD: str = Field('postgres', env='PG_LOCAL_PASSWORD')
    POSTGRES_HOST: str = Field('localhost', env='PG_LOCAL_HOST')
    POSTGRES_PORT: int = Field(5432, env='PG_LOCAL_PORT')

    TELEGRAM_TOKEN: str = '123:FAKE_TOKEN'
    STAFF_API_TOKEN: str = 'fake_staff_token'
    STACK_API_KEY: str = 'fake_api_key'
    STACK_ACCESS_TOKEN: str = 'fake_access_token'

    TVM2_CLIENT: str = 'fake_client'
    TVM2_SECRET: SecretStr = 'fake_secret'

    STACK_API_HOSTS: list = [
        'http://stackoverflow.yandex-team.ru/',
    ]

    LOGBROKER_TOKEN: str = 'token'
    LOGBROKER_TOPIC: str = 'some-topic'
    LOGBROKER_PRODUCER: str = 'some-producer'

    STARTREK_API_TOKEN: str = 'fake_startrek_token'
