from .default import Settings as DefaultSettings
from celery.schedules import crontab


class Settings(DefaultSettings):
    ENV_TYPE: str = 'production'
    DEBUG: bool = False

    CELERY_BEAT_SCHEDULE = {
        'synchronize_bot_users': {
            'task': 'stackbot.tasks.synchronize_bot_users',
            'schedule': crontab(minute=0, hour=12),
        },
        'process_recent_active_questions': {
            'task': 'stackbot.tasks.process_recent_active_questions',
            'schedule': crontab(),
        },
        'send_question_posted_event': {
            'task': 'stackbot.tasks.send_question_posted_event',
            'schedule': crontab(),
        },
        'send_unanswered_digest': {
            'task': 'stackbot.tasks.send_unanswered_digest',
            'schedule': crontab(minute=0, hour=11, day_of_week=5),
        },
    }

    TVM2_SERVICES: dict = {
        'gozora': 2023123,
        'startrek': 176,
    }

    STARTREK_QUEUE: str = 'STACKOVERFLOW'

    COMPONENT_ID_QUESTION: int = 112891
    COMPONENT_ID_ANSWER: int = 112892
    SO_UPVOTES_ID: str = '62627ce407f47f0f7f5c19be--soUpvotes'
