from sqlalchemy import (
    Column,
    types,
)

from stackbot.enums import (
    BotUserState,
)
from stackbot.db.base import (
    BaseModel,
    TimestampedModelMixin,
)


class BotUser(TimestampedModelMixin, BaseModel):
    __tablename__ = 'bot_user'

    id = Column(types.Integer, primary_key=True, index=True)
    telegram_id = Column(types.String, index=True, unique=True, nullable=True)
    username = Column(types.String, unique=True, nullable=True)

    staff_id = Column(types.Integer)
    staff_uid = Column(types.String, nullable=False, unique=True)
    staff_login = Column(types.String, default='')

    state = Column(types.Enum(BotUserState), nullable=False)
