from sqlalchemy import (
    Column,
    types,
)

from stackbot.enums import (
    EventType,
    EventState,
    LogbrokerEventType,
    LogbrokerEventState,
)
from stackbot.db.base import (
    BaseModel,
    TimestampedModelMixin,
)


class Event(TimestampedModelMixin, BaseModel):
    __tablename__ = 'event'

    id = Column(types.Integer, primary_key=True, index=True)
    event_id = Column(types.Integer, nullable=False, index=True)
    type = Column(
        types.Enum(EventType),
        nullable=False,
    )
    state = Column(
        types.Enum(EventState),
        nullable=False,
        default=EventState.new,
    )


class LogbrokerEvent(TimestampedModelMixin, BaseModel):
    __tablename__ = 'logbroker_event'

    id = Column(types.Integer, primary_key=True, index=True)
    creation_date = Column(types.Integer, index=True)

    event_id = Column(types.Integer, nullable=False, index=True)
    link = Column(types.String, nullable=False)
    type = Column(
        types.Enum(LogbrokerEventType),
        nullable=False,
    )
    state = Column(
        types.Enum(LogbrokerEventState),
        nullable=False,
        default=LogbrokerEventState.new,
    )

    def get_key(self) -> tuple[int, int]:
        return self.event_id, self.creation_date
