from sqlalchemy import (
    Column,
    types,
)

from stackbot.db.base import (
    BaseModel,
    TimestampedModelMixin,
)


class StackUser(TimestampedModelMixin, BaseModel):
    __tablename__ = 'stack_user'

    id = Column(types.Integer, primary_key=True, index=True)
    display_name = Column(types.String, unique=True, nullable=False)
    accepted_count = Column(types.Integer, nullable=False)
