from enum import Enum, auto


class AutoName(str, Enum):
    def _generate_next_value_(name, start, count, last_values):
        return name


class ChatType(AutoName):
    private = auto()
    group = auto()
    channel = auto()
    supergroup = auto()

    @classmethod
    def group_types(cls) -> set:
        return {
            cls.group,
            cls.channel,
            cls.supergroup,
        }


class SubscriptionType(AutoName):
    chat = auto()
    email = auto()


class EventState(AutoName):
    new = auto()
    done = auto()


class LogbrokerEventState(AutoName):
    new = auto()
    sent = auto()


class SubscriptionEventState(AutoName):
    new = auto()
    send = auto()
    rejected = auto()


class EventType(AutoName):
    question_posted = auto()
    answer_posted = auto()
    comment_posted = auto()
    post_edited = auto()


class LogbrokerEventType(AutoName):
    question_posted = auto()
    answer_posted = auto()
    comment_posted = auto()
    post_edited = auto()


class BotUserState(AutoName):
    active = auto()
    deprived = auto()


class AskStates(Enum):
    REPLY_TITLE = auto()
    REPLY_TAGS = auto()
    REPLY_BODY = auto()
    PREVIEW_QUESTION = auto()
    CONFIRM_TAGS = auto()
