import sys

from stackbot.config import settings


LOG_FORMAT = 'json' if settings.ENV_TYPE != 'development' else 'default'
ENV_LOG_LEVEL = 'DEBUG' if settings.DEBUG or settings.ENV_TYPE == 'development' else 'INFO'

LOGGING_CONFIG = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            '()': 'ylog.context.ContextFormatter',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'format': '[%(asctime)s][%(name)s] - %(levelname)s - %(message)s',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
        },
    },
    'handlers': {
        'stream': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMAT,
            'stream': sys.stdout,
            'level': ENV_LOG_LEVEL,
        },
    },
    'loggers': {
        'tvm2.aio.base': {
            'handlers': ['stream'],
            'level': ENV_LOG_LEVEL,
            'propagate': False,
        },
        'telegram': {
            'handlers': ['stream'],
            'level': 'INFO',
            'propagate': False,
        },
        'apscheduler': {
            'handlers': ['stream'],
            'level': 'INFO',
            'propagate': False,
        },
        'stackbot': {
            'handlers': ['stream'],
            'level': ENV_LOG_LEVEL,
            'propagate': False,
        },
        'urllib3': {
            'handlers': ['stream'],
            'level': ENV_LOG_LEVEL,
            'propagate': False,
        },
        'ya.test': {
            'level': 'WARNING'
        },
        'httpx.client': {
            'level': 'WARNING'
        },
        'ydb.connection': {
            'level': 'INFO' if ENV_LOG_LEVEL == 'DEBUG' else ENV_LOG_LEVEL
        }
    },
    'root': {
        'handlers': ['stream'],
        'level': ENV_LOG_LEVEL,
    },
}
