from tvm2.sync.thread_tvm2 import TVM2
from stackbot.config import settings


def get_tvm2_ticket(destination: str):
    client = get_tvm2_client()
    tvm_id = settings.TVM2_SERVICES[destination]
    return client.get_service_ticket(tvm_id)


def get_tvm2_client() -> TVM2:
    secret = settings.TVM2_SECRET.get_secret_value()
    return TVM2(
        client_id=settings.TVM2_CLIENT,
        secret=secret,
        blackbox_client=settings.TVM2_BLACKBOX_CLIENT,
        allowed_clients=[],
        destinations=settings.TVM2_SERVICES.values(),
    )
