import os
import subprocess

from logging.config import dictConfig

from .config import settings


def dbshell():
    pgshell = os.environ.get('PGSHELL', 'pgcli')

    db_settings = settings.db_settings
    command = ''

    if db_settings.get('password'):
        command = 'PGPASSWORD={password} '.format(
            password=db_settings.get('password'))

    target_session_attrs_opt = 'target_session_attrs=read-write'

    command += (
        '{pgshell} -d "'
        'host={host} '
        'port={port} '
        'sslmode=verify-full '
        'dbname={database} '
        'user={user} '
        '{target_session_attrs_opt}"'
    ).format(
        pgshell=pgshell,
        target_session_attrs_opt=target_session_attrs_opt,
        **db_settings
    )
    subprocess.call(command, shell=True)


def celery_manage():
    from .logconfig import LOGGING_CONFIG  # noqa: F401
    dictConfig(LOGGING_CONFIG)
    from . import celery_app  # noqa: F401
    from celery.bin.celery import main
    return main()
