import yt.wrapper as yt
import logging

from stackbot.logic.clients.stack import StackClient
from stackbot.logic.clients.staff import staff_client
from stackbot.logic.utils import get_chunks

logger = logging.getLogger(__name__)

__yt_cluster__ = 'hahn'
__update_latest_link__ = True
__yt_q_schema__ = [
    {'name': 'answer_count', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'creation_date', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'is_answered', 'type': 'boolean', 'type_v3': 'bool'},
    {'name': 'accepted_answer_id', 'type': 'int64', 'required': False},
    {'name': 'last_activity_date', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'last_edit_date', 'type': 'int64', 'required': False},
    {'name': 'closed_date', 'type': 'int64', 'required': False},
    {'name': 'locked_date', 'type': 'int64', 'required': False},
    {'name': 'closed_reason', 'type': 'string', 'required': False},
    {'name': 'link', 'type': 'string', 'type_v3': 'string'},
    {'name': 'owner', 'type': 'any', 'type_v3': {
        'type_name': 'struct',
        'members': [
            {'name': 'account_id', 'type': 'int64'},
            {'name': 'display_name', 'type': 'string'},
            {'name': 'link', 'type': 'string'},
            {'name': 'deps', 'type': 'string'},
            {'name': 'position', 'type': 'string'},
            {'name': 'profile_image', 'type': 'string'},
            {'name': 'reputation', 'type': 'int64'},
            {'name': 'user_id', 'type': 'int64'},
            {'name': 'user_type', 'type': 'string'}
        ]
    }},
    {'name': 'question_id', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'score', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'tags', 'type': 'any', 'type_v3': {'item': 'string', 'type_name': 'list'}},
    {'name': 'title', 'type': 'string', 'type_v3': 'string'},
    {'name': 'view_count', 'type': 'int64', 'type_v3': 'int64'}
]

__yt_a_schema__ = [
    {'name': 'owner', 'type': 'any',
     'type_v3': {
         'type_name': 'struct',
         'members': [
             {'name': 'account_id', 'type': 'int64'},
             {'name': 'deps', 'type': 'string'},
             {'name': 'position', 'type': 'string'},
             {'name': 'display_name', 'type': 'string'},
             {'name': 'link', 'type': 'string'},
             {'name': 'profile_image', 'type': 'string'},
             {'name': 'reputation', 'type': 'int64'},
             {'name': 'user_id', 'type': 'int64'},
             {'name': 'user_type', 'type': 'string'}
         ]
    }},
    {'name': 'is_accepted', 'type': 'boolean', 'type_v3': 'bool'},
    {'name': 'score', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'last_activity_date', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'creation_date', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'last_edit_date', 'type': 'int64', 'required': False},
    {'name': 'answer_id', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'question_id', 'type': 'int64', 'type_v3': 'int64'}
]

__yt_u_schema__ = [
    {'name': 'badge_counts', 'type': 'any',
     'type_v3': {'type_name': 'struct', 'members': [
         {'name': 'bronze', 'type': 'int64'},
         {'name': 'gold', 'type': 'int64'},
         {'name': 'silver', 'type': 'int64'}
     ]}},
    {'name': 'account_id', 'type': 'int64', 'required': False},
    {'name': 'is_employee', 'type': 'boolean', 'type_v3': 'bool'},
    {'name': 'last_access_date', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'last_modified_date', 'type': 'int64', 'required': False},
    {'name': 'reputation_change_year', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'reputation_change_quarter', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'reputation_change_month', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'reputation_change_week', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'reputation_change_day', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'reputation', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'creation_date', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'user_type', 'type': 'string', 'type_v3': 'string'},
    {'name': 'location', 'type': 'string', 'required': False},
    {'name': 'user_id', 'type': 'int64', 'type_v3': 'int64'},
    {'name': 'website_url', 'type': 'string', 'required': False},
    {'name': 'link', 'type': 'string', 'type_v3': 'string'},
    {'name': 'profile_image', 'type': 'string', 'required': False},
    {'name': 'display_name', 'type': 'string', 'type_v3': 'string'}
]

__yt_q_path__ = '//home/stackoverflow/questions'
__yt_a_path__ = '//home/stackoverflow/answers'
__yt_u_path__ = '//home/stackoverflow/users'
__yt_latest_link__ = '{}/latest'


def save_from_so_to_yt(yt_client, method, table_path):
    logger.info(f'Saving {method} to {table_path}')
    client = StackClient()

    result = getattr(client, method)()
    items = []
    logins = [
        item['owner']['display_name']
        for item in result
        if item.get('owner', {}).get('display_name')
    ]
    user_departments = staff_client.get_department_by_logins(
        logins=logins,
    )
    for item in result:
        display_name = item.get('owner', {}).get('display_name')
        if display_name:
            item['owner'].update(
                user_departments.get(
                    display_name,
                    {'deps': '', 'position': ''},
                )
            )
        items.append(item)

    for chunk in get_chunks(items, size=200):
        yt_client.write_table(yt.TablePath(table_path, append=True), chunk)
    logger.info(f'Method: {method}, write total rows: {len(items)}')


def create_yt_table(yt_client, path, schema):
    if yt_client.exists(path):
        yt_client.remove(path)
    yt_client.create("table", path, attributes={"schema": schema})


def create_latest_link(yt_client, directory, table):
    if __update_latest_link__:
        link_path = __yt_latest_link__.format(directory)
        yt_client.link(table, link_path, force=True)
