PY3_PROGRAM(stackbot.bot)

OWNER(g:tools-abc)

PEERDIR(
    contrib/python/requests
    contrib/python/psycopg2
    contrib/python/pydantic
    contrib/python/ipython
    contrib/python/sqlalchemy/sqlalchemy-1.4
    contrib/python/python-telegram-bot
    contrib/python/celery/py2
    contrib/python/boto3
    contrib/python/pycurl

    library/python/ylog
    library/python/tvm2
    library/python/startrek_python_client
    kikimr/public/sdk/python/persqueue
    yt/python/client
)

PY_SRCS(
    TOP_LEVEL
    stackbot/main.py
    stackbot/logconfig.py
    stackbot/enums.py
    stackbot/tasks.py
    stackbot/so_stat_task.py
    stackbot/so_migrate_to_st.py
    stackbot/manage.py
    stackbot/logic/tvm_client.py
    stackbot/logic/utils.py
    stackbot/logic/logbroker.py
    stackbot/logic/clients/base.py
    stackbot/logic/clients/stack.py
    stackbot/logic/clients/startrek.py
    stackbot/logic/clients/staff.py
    stackbot/logic/clients/achievery.py
    stackbot/celery_app.py
    stackbot/db/__init__.py
    stackbot/db/base.py
    stackbot/db/event.py
    stackbot/db/subscription.py
    stackbot/db/bot_user.py
    stackbot/db/stack_user.py
    stackbot/config/__init__.py
    stackbot/config/default.py
    stackbot/config/development.py
    stackbot/config/testing.py
    stackbot/config/production.py
)

PY_MAIN(stackbot.main:main)

END()
