# coding: utf-8

from django.conf.urls import patterns, include, url
from django.conf.urls.static import static
from django.conf import settings
from django.views.generic.base import RedirectView
from django.core.urlresolvers import reverse_lazy

import static_api

from staff_api.v3_0.idm.views import list_fields_access


urlpatterns = patterns(
    '',
    url(
        r'^$',
        RedirectView.as_view(
            url=reverse_lazy('static_api:index'),
            permanent=False,
        ),
        name='root',
    ),
    url(
        r'^v3/',
        include(static_api.urls.urls),
    ),
    url(
        r'^idm/',
        include('django_idm_api.urls', namespace='idm-api'),
    ),
    url(
        r'^list_fields_access/(?P<subject_type>[a-z_]+)/(?P<subject>[\w\-_.]+)/?',
        list_fields_access,
        name='list-fields-access',
    ),
)

urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
