# coding: utf-8
from __future__ import unicode_literals

import logging

from static_api.dehydrators import Dehydrator


logger = logging.getLogger(__name__)


class GeographyNestedDehydrator(Dehydrator):
    fields = [
        'id',
        'is_deleted',
        'name',
        'url',
        'level',
        '_meta',
    ]

    def __init__(self, data, namespace):
        super(GeographyNestedDehydrator, self).__init__(data)
        self._namespace = namespace


class GeographyDehydrator(GeographyNestedDehydrator):
    fields = GeographyNestedDehydrator.fields + [
        'parent',
        'ancestors',
        'oebs_code',
        'st_translation_id',
    ]

    def get_oebs_code(self):
        return self._get_existing_value('oebs_code')

    def get_st_translation_id(self):
        return self._get_existing_value('st_translation_id')

    def _get_existing_value(self, key):
        existing = self._namespace.geography.get_one({'id': self._get_raw_value('id')})

        if existing:
            return existing.get(key)

        return None

    def get_ancestors(self):
        ancestors = []
        parent = self._find_parent()

        if parent is not None:
            ancestors = parent.get('ancestors', [])
            ancestors += [parent]

        return [GeographyNestedDehydrator(geography, self._namespace).as_dict() for geography in ancestors]

    def get_parent(self):
        parent = self._find_parent()

        if parent is not None:
            return GeographyNestedDehydrator(parent, self._namespace).as_dict()

        return None

    def _get_raw_value(self, key):
        return self.get_raw(key).get(key)

    def _find_parent(self):
        parent_id = self._get_raw_value('parent')

        if parent_id is not None:
            parent = self._namespace.geography.get_one({'id': parent_id})

            if parent:
                return parent

            logger.error('Cannot find geography parent: %s', parent_id)
            raise ValueError('Group refers to non existent parent')

        return None


class GeographyPatchDehydrator(Dehydrator):
    fields = [
        'oebs_code',
        'st_translation_id',
    ]
