# coding: utf-8
from __future__ import unicode_literals

from static_api.dehydrators import Dehydrator


class OrganizationDehydrator(Dehydrator):
    fields = (
        '_meta',
        'is_deleted',
        'id',
        'name',
        'name_en',
        'created_at',
        'country_code',
    )


class OrganizationRefDehydrator(Dehydrator):
    fields = (
        'is_deleted',
        'id',
        'name',
        'name_en',
    )


class CountryDehydrator(Dehydrator):
    fields = (
        'is_deleted',
        'id',

        'name',
        'code',
        'created_at',
        'geobase',
        'domain',
    )


class CountryRefDehydrator(Dehydrator):
    fields = CountryDehydrator.fields


class CityDehydrator(Dehydrator):
    fields = (
        'is_deleted',
        'id',

        'name',
        'code',
        'created_at',

        'country',
    )

    def get_country(self):
        return CountryRefDehydrator(self.data['country']).as_dict()


class CityRefDehydrator(Dehydrator):
    fields = CityDehydrator.fields


class CityMixin(object):
    def get_city(self):
        return CityRefDehydrator(self.data.get('city', {})).as_dict()


class OfficeRefDehydrator(CityMixin, Dehydrator):
    fields = (
        'is_deleted',
        'id',
        'created_at'
        'city',
        'name',
        'is_virtual',
        'contacts',
        'address',
        'timezone',
        'city',
        'code',
        'have_map',
    )


class OfficeDehydrator(OfficeRefDehydrator):
    fields = OfficeRefDehydrator.fields + ('_meta', 'floors')

    def get_floors(self):
        return [FloorRefNestedDehydrator(floor).as_dict() for floor in self.data.get('floors', [])]


class OfficeMixin(object):
    def get_office(self):
        return OfficeRefDehydrator(self.data.get('office', {})).as_dict()


class FloorDehydrator(OfficeMixin, Dehydrator):
    fields = (
        'is_deleted',
        'id',
        'created_at',
        'name',
        'office',
        'number',
        'image',
    )


class FloorRefDehydrator(OfficeMixin, Dehydrator):
    fields = (
        'is_deleted',
        'id',
        'name',
        'number',
        'office',
        'image',
    )


class FloorRefNestedDehydrator(Dehydrator):
    fields = (
        'is_deleted',
        'id',
        'name',
        'number',
        'image',
    )


class FloorMixin(object):
    def get_floor(self):
        return FloorRefDehydrator(self.data.get('floor', {})).as_dict()


class RoomMixin(object):
    def get_room(self):
        return RoomRefDehydrator(self.data.get('room', {})).as_dict()


class TableDehydrator(RoomMixin, FloorMixin, Dehydrator):
    fields = (
        '_meta',
        'id',
        'number',
        'created_at',
        'floor',
        'room',
        'location',
    )


class TableRefDehydrator(RoomMixin, FloorMixin, Dehydrator):
    fields = (
        'id',
        'number',
        'floor',
        'room',
    )


class RoomDehydrator(FloorMixin, Dehydrator):
    fields = (
        '_meta',
        'is_deleted',
        'id',
        'type',
        'floor',
        'location',
        'number',
        'equipment',
        'name',
        'phone',
        'capacity',
        'is_bookable',
        'is_cabin',
        'additional',
        'created_at',
    )


class RoomRefDehydrator(Dehydrator):
    fields = (
        'id',
        'number',
        'name',
    )


class EquipmentDehydrator(FloorMixin, Dehydrator):
    fields = (
        '_meta',
        'is_deleted',
        'id',
        'description',
        'created_at',
        'floor',
        'location',
        'type',
        'name',
        'hostname',
        'floor',
    )
