# coding: utf-8
from __future__ import unicode_literals

from static_api.dehydrators import Dehydrator


class PersonDehydrator(Dehydrator):
    fields = (
        '_meta',
        'is_deleted',
        'created_at',
        'login',
        'uid',
        'guid',
        'work_phone',
        'work_email',
        'work_mode',

        'id',

        'location',
        'name',
        'personal',
        'education',
        'official',
        'language',
        'contacts',
        'environment',
        'images',

        'yandex',

        'department_group',
        'chief',
        'chiefs',
        'hr_partners',

        'phones',
        'cars',
        'bicycles',
        'keys',
        'gpg_keys',
        'emails',
        'accounts',
        'personal_emails',
        'telegram_accounts',
        'skype_accounts',

        'memorial',
        'robot_users',
        'robot_owners',
    )

    def get_department_group(self):
        from .group import GroupRefDehydrator

        return GroupRefDehydrator(self.data['department_group']).as_dict()

    def get_location(self):
        from .office import OfficeRefDehydrator, TableRefDehydrator, RoomRefDehydrator

        location = self.data['location']

        return dict(
            location,
            office=OfficeRefDehydrator(location['office']).as_dict(),
            table=TableRefDehydrator(location['table']).as_dict(),
            room=RoomRefDehydrator(location['room']).as_dict(),
        )

    def get_official(self):
        from .office import OrganizationRefDehydrator

        official = self.data['official']

        return dict(official,
                    organization=OrganizationRefDehydrator(official['organization']).as_dict())

    def get_phones(self):
        return [PersonPhoneRefDehydrator(phone).as_dict() for phone in self.data['phones']]

    def get_cars(self):
        return [PersonCarRefDehydrator(car).as_dict() for car in self.data['cars']]

    def get_bicycles(self):
        return [PersonBicycleRefDehydrator(bicycle).as_dict() for bicycle in self.data['bicycles']]

    def get_keys(self):
        return [PersonKeyRefDehydrator(key).as_dict() for key in self.data['keys']]

    def get_gpg_keys(self):
        return [PersonGpgKeyRefDehydrator(gpg_key).as_dict() for gpg_key in self.data['gpg_keys']]

    def get_emails(self):
        return [PersonEmailRefDehydrator(key).as_dict() for key in self.data['emails']]

    def get_accounts(self):
        return [PersonAccountRefDehydrator(account).as_dict() for account in self.data['accounts']]

    def get_personal_emails(self):
        return [
            PersonAccountRefWithoutTypeDehydrator(account).as_dict()
            for account in self.data['accounts'] if account['type'] == 'personal_email'
        ]

    def get_telegram_accounts(self):
        return [
            PersonAccountRefWithoutTypeDehydrator(account).as_dict()
            for account in self.data['accounts'] if account['type'] == 'telegram'
        ]

    def get_skype_accounts(self):
        return [
            PersonAccountRefWithoutTypeDehydrator(account).as_dict()
            for account in self.data['accounts'] if account['type'] == 'skype'
        ]

    def get_memorial(self):
        if self.data['memorial']:
            return MemorialProfileRefDehydrator(self.data['memorial']).as_dict()

    def get_robot_users(self):
        return [
            PersonResponsibleForRobotRefDehydrator(robot_user).as_dict()
            for robot_user in self.data['robot_users']
        ]

    def get_robot_owners(self):
        return [
            PersonResponsibleForRobotRefDehydrator(robot_owner).as_dict()
            for robot_owner in self.data['robot_owners']
        ]


class PersonRefDehydrator(Dehydrator):
    fields = (
        'is_deleted',
        'id',
        'uid',
        'login',
        'name.first',
        'name.last',
        'name.first_en',
        'name.last_en',
        'official.is_dismissed',
        'official.is_robot',
        'official.is_homeworker',
        'official.affiliation',
    )


class PersonNewRefDehydrator(Dehydrator):
    fields = (
        'id',
        'uid',
        'login',
        'name.first',
        'name.last',
        'name.first_en',
        'name.last_en',
    )


class PersonRefDehydratorMixin(object):
    def get_person(self):
        return PersonRefDehydrator(self.data['person']).as_dict()


class PersonPhoneRefDehydrator(Dehydrator):
    fields = (
        'id',
        'number',
        'type',
        'description',
        'kind',
        'protocol',
        'is_main',
        'for_digital_sign',
    )


class PersonPhoneDehydrator(Dehydrator):
    fields = PersonPhoneRefDehydrator.fields + ('person',)


class PersonCarRefDehydrator(Dehydrator):
    fields = (
        'id',
        'model',
        'plate',
    )


class PersonCarDehydrator(Dehydrator):
    fields = PersonCarRefDehydrator.fields + ('person',)


class PersonBicycleRefDehydrator(Dehydrator):
    fields = (
        'id',
        'plate',
        'description',
    )


class PersonBicycleDehydrator(Dehydrator):
    fields = PersonBicycleRefDehydrator.fields + ('person',)


class PersonKeyRefDehydrator(Dehydrator):
    fields = (
        'id',
        'description',
        'key',
        'fingerprint',
        'fingerprint_sha256',
    )


class PersonKeyDehydrator(Dehydrator):
    fields = PersonKeyRefDehydrator.fields + ('person',)


class PersonGpgKeyRefDehydrator(Dehydrator):
    fields = (
        'id',
        'description',
        'key',
        'fingerprint',
    )


class PersonGpgKeyDehydrator(Dehydrator):
    fields = PersonGpgKeyRefDehydrator.fields + ('person',)


class PersonEmailRefDehydrator(Dehydrator):
    fields = (
        'id',
        'source_type',
        'address',
    )


class PersonEmailDehydrator(Dehydrator):
    fields = PersonEmailRefDehydrator.fields + ('person',)


class MemorialProfileRefDehydrator(Dehydrator):
    fields = (
        'id',
        'death_date',
    )


class MemorialProfileDehydrator(Dehydrator):
    fields = MemorialProfileRefDehydrator.fields + ('person',)


class PersonExtraFieldsDehydrator(Dehydrator):
    fields = (
        'id',
        'nda_ended_at',
        'contract_ended_at',
        'has_byod_access',
        'wiretap',
        'staff_agreement',
        'staff_biometric_agreement',
    )


class PersonExtraFieldsPersonDehydrator(Dehydrator):
    fields = (
        'official',
    )

    def get_official(self):
        return {
            'nda_ended_at': self.data['nda_ended_at'],
            'contract_ended_at': self.data['contract_ended_at'],
            'has_byod_access': self.data['has_byod_access'],
            'wiretap': self.data['wiretap'],
            'staff_agreement': self.data['staff_agreement'],
            'staff_biometric_agreement': self.data['staff_biometric_agreement'],
        }


class PersonAccountRefWithoutTypeDehydrator(Dehydrator):
    fields = (
        'id',
        'value',
        'private',
        'value_lower',
    )


class PersonAccountRefDehydrator(Dehydrator):
    fields = PersonAccountRefWithoutTypeDehydrator.fields + ('type',)
    fields = (
        'id',
        'type',
        'value',
        'private',
        'value_lower',
    )


class PersonAccountDehydrator(Dehydrator):
    fields = PersonAccountRefDehydrator.fields + ('person',)


class PersonResponsibleForRobotDehydrator(PersonRefDehydratorMixin, Dehydrator):
    fields = (
        'id',
        'person',
        'robot',
        'role',
    )


class PersonResponsibleForRobotRefDehydrator(PersonRefDehydratorMixin, Dehydrator):
    fields = (
        'id',
        'person',
    )
