# coding: utf-8
from __future__ import unicode_literals

from static_api.fields import Fieldset


class PersonFieldset(Fieldset):
    thumbnail = {
        '_id': 0,

        'is_deleted': 1,
        'id': 1,
        'uid': 1,

        'name.first': 1,
        'name.last': 1,

        'login': 1,
        'official.is_dismissed': 1,
        'official.is_robot': 1,
        'official.is_homeworker': 1,
        'official.affiliation': 1,
    }

    one = {
        '_id': 0,
        '_meta': 0,

        'cars.id': 0,

        'bicycles.id': 0,

        'accounts.id': 0,

        'phones.id': 0,

        'keys.id': 0,

        'gpg_keys.id': 0,

        'emails.id': 0,
    }


class GroupFieldset(Fieldset):
    thumbnail = {
        '_id': 0,

        'is_deleted': 1,
        'id': 1,
        'name': 1,
        'url': 1,
        'type': 1,

        'department.id': 1,
        'service.id': 1,
    }

    one = {
        '_id': 0,
        '_meta': 0,

        'department.heads.id': 0,

        'ancestors.department.heads.id': 0,
    }


def _prefix_fields(prefix, fields):
    return [
        ('%s.%s' % (prefix, name), value)
        for name, value in fields.iteritems()
        if name not in ('_id',)
    ]


class GroupmembershipFieldset(Fieldset):
    thumbnail = dict(
        _prefix_fields('person', PersonFieldset.thumbnail) +
        _prefix_fields('group', GroupFieldset.thumbnail),
        _id=0,
        id=1,
        joined_at=1,
    )

    one = dict(
        _prefix_fields('person', PersonFieldset.one) +
        _prefix_fields('group', GroupFieldset.one),
        _id=0,
        _meta=0,
    )


class OrganizationFieldset(Fieldset):
    thumbnail = one = {
        '_id': 0,
        '_meta': 0,
    }


class OfficeFieldset(Fieldset):
    thumbnail = one = {
        '_id': 0,
        '_meta': 0,
    }


class TableFieldset(Fieldset):
    thumbnail = one = {
        '_id': 0,
        '_meta': 0,
    }


class RoomFieldset(Fieldset):
    thumbnail = one = {
        '_id': 0,
        '_meta': 0,
    }


class EquipmentFieldset(Fieldset):
    thumbnail = one = {
        '_id': 0,
        '_meta': 0,
    }


class DepartmentStaff(Fieldset):
    thumbnail = one = {
        '_id': 0,
        '_meta': 0,
        'department': 0,
    }


class PositionFieldset(Fieldset):
    thumbnail = one = {
        '_id': 0,
        '_meta': 0,
    }


class OccupationFieldset(Fieldset):
    thumbnail = one = {
        '_id': 0,
        '_meta': 0,
    }


class GeographyFieldset(Fieldset):
    thumbnail = {
        '_id': 0,
        'id': 1,
        'is_deleted': 1,
        'url': 1,
        'name': 1,
        'oebs_code': 1,
        'st_translation_id': 1,
    }

    one = {
        '_meta': 0,
        'level': 1,
        'ancestors': 1,
        'parent': 1,
    }
