

class ActionRegistry(object):
    actions = {}

    @classmethod
    def register(cls, role_type, role):
        def inner(action_class):
            cls.actions[(role_type, role)] = action_class
            return action_class
        return inner

    @classmethod
    def get(cls, role_type, role):
        return cls.actions.get((role_type, role))
