# coding: utf-8
from celery import shared_task

from static_api.lock import locked
from staff_api.v3_0.idm.db_collections import idm_roles_collection
from staff_api.v3_0.idm.sync import IDM_ROLE_FIELDS_BASE, FieldsAccessSync


@shared_task
@locked('sync_fields_access_rules')
def sync_fields_access_rules():
    idm_roles = idm_roles_collection.find(
        filter={'handled': False},
        projection=IDM_ROLE_FIELDS_BASE,
        limit=10000,
    )
    syncer = FieldsAccessSync(idm_roles=idm_roles)
    syncer.sync()
