# coding: utf-8

from django.http import JsonResponse

from static_api.resources import registry
from static_api.views.resource import _get_fields_access_from_mongo

from staff_api.v3_0.idm.helpers import get_person_uid_by_login


def list_fields_access(request, subject_type, subject):
    if subject_type == 'tvm_app':
        subject_id = subject
    elif subject_type == 'user':
        subject_id = get_person_uid_by_login(subject)
    else:
        return JsonResponse(data={'error': 'Unknown subject_type: %s' % subject_type}, status=400)

    if not subject_id:
        return JsonResponse(data={'error': 'Unknown subject: %s' % subject}, status=400)

    result = {}
    for resource_name, resource in registry.by_name.items():
        result[resource_name] = sorted(list(_get_fields_access_from_mongo(subject_type, subject_id, resource)))

    return JsonResponse(data=result, status=200)
