# coding: utf-8
from __future__ import unicode_literals
from staff_api.v3_0.idm.workflows.idm_context import *  # noqa

# workflow code starts here
#=====================================================
# копировать код workflow, начиная отсюда

from urlparse import urlparse, parse_qs

RESOURCE_PLURAL = {
    'departmentstaff': 'departmentstaff',
    'equipment': 'equipment',
    'geography': 'geographies',
    'group': 'groups',
    'groupmembership': 'groupmembership',
    'occupation': 'occupations',
    'office': 'offices',
    'organization': 'organizations',
    'person': 'persons',
    'position': 'positions',
    'room': 'rooms',
    'table': 'tables',
}


def validate_role_type(role_type):
    if role_type != 'resource_access':
        raise AccessDenied('Для этого типа ролей workflow не определён')


def validate_resource(resource):
    if resource not in RESOURCE_PLURAL:
        raise AccessDenied(
            '%s — новый ресурс. Напишите в поддержку Стаффа, '
            'что нужно обновить workflow staff-api' % resource
        )


def validate_access_url(access_url, resource):
    if not access_url:
        raise AccessDenied('Ссылка — обязательное поле')
    access_url = access_url.strip()
    parsed = urlparse(access_url)
    if resource not in parsed.path and RESOURCE_PLURAL[resource] not in parsed.path:
        raise AccessDenied('Ссылка должна быть на запрашиваемый ресурс')

    params = parse_qs(parsed.query)
    if '_fields' not in params:
        raise AccessDenied(
            'Ссылка должна содержать параметр _fields с перечислением полей, '
            'доступ к которым запрашивается'
        )

    requested_access_fields = set(params['_fields'][0].split(','))
    if '_all' in requested_access_fields:
        raise AccessDenied(
            'Если нужен доступ ко всем полям, запросите полный доступ к ресурсу'
        )


############

resource = role.get('resource')
access_type = role.get('access_type')

validate_role_type(role.get('role_type'))
validate_resource(resource)

if access_type == 'partial_access':
    access_url = fields_data.get('access_url', '') if fields_data else ''
    validate_access_url(access_url, resource)

approvers = any_from(groupify(147719).members)  # sib

# Дублируем роль в staffapi-test
staffapi_test_role = {
    'system': 'staffapi-test',
    'role_data': role,
}
if fields_data:
    staffapi_test_role.update(role_fields=fields_data)
ref_roles = [staffapi_test_role]
