# coding: utf-8
from __future__ import unicode_literals

def some_idm_function(function=None):
    stub_function = lambda *args, **kwargs: None
    return function or stub_function

class IDMBase(object):
    def __init__(self, **params):
        for key, value in params.items():
            if key.startswith('_'):
                setattr(self, key, value)


    def __getattr__(self, item):
        key = '_' + item
        if key in self.__dict__:
            return getattr(self, key)
        raise AttributeError()


class IDMGroup(IDMBase):
    """https://wiki.yandex-team.ru/intranet/idm/workflow/group/"""
    def __init__(self, **params):
        super(IDMGroup, self).__init__(**params)
        self.type = params.get('type', 'department')
        self.external_id = params.get('external_id', -1)
        self.slug = params.get('slug', 'someslug')


class IDMUser(IDMBase):
    """https://wiki.yandex-team.ru/intranet/idm/workflow/user/"""
    def __init__(self, **params):
        super(IDMUser, self).__init__(**params)
        self.username = params.get('username', '')
        self.email = params.get('email', '')
        self.lang_ui = params.get('lang_ui', '')
        self.center_id = params.get('center_id', -1)
        self.department_group = params.get('department_group', 'group')
        self.is_robot = params.get('is_robot', False)
        self.affiliation = params.get('affiliation', 'yandex')


class IDMSystem(IDMBase):
    """https://wiki.yandex-team.ru/intranet/idm/workflow/system/"""
    def __init__(self, **params):
        super(IDMSystem, self).__init__(**params)
        self.slug = params.get('slug', 'someslug')

class IDMNode(IDMBase):
    """https://wiki.yandex-team.ru/intranet/idm/workflow/node/"""
    def __init__(self, **params):
        super(IDMNode, self).__init__(**params)


class AccessDenied(Exception):
    pass


class Return(Exception):
    pass


# https://wiki.yandex-team.ru/intranet/idm/workflow/#dostupnyefunkcii
approver = some_idm_function()
any_from = some_idm_function()
recipient = some_idm_function()
systemify = some_idm_function()
groupify = some_idm_function(lambda gid: IDMGroup(_members=[]))
find_conflicts = some_idm_function()


# https://wiki.yandex-team.ru/intranet/idm/workflow/#dostupnyeobekty
requester = IDMUser()
original_requester = IDMUser()
user = IDMUser()
group = IDMGroup()
role = {'role_type': 'resource_access', 'access_type': 'full_access', 'resource': 'person'}
system = IDMSystem()
node = IDMNode()
fields_data = {}
scope = ''
ignore_approvers = True
request_type = 'request'
inheritance_settings = {}


# https://wiki.yandex-team.ru/intranet/idm/workflow/#wf-artifacts
approvers = []
notify_everyone = None
send_sms = False
ad_groups = []
email_cc = None
ttl_days = None
review_days = None
no_email = False
ref_roles = []
workflow_comment = None
warnings = []
conflicts = None
conflict_comment = ''
