# coding: utf-8
from __future__ import unicode_literals

from staff_api.v3_0.idm.workflows.idm_context import *  # noqa

# В коде workflow можно пользоваться только stdlib
#=====================================================
# копировать код workflow, начиная отсюда
import re
import itertools
from urlparse import urlparse, parse_qs

PERSON = 'person'
GROUP = 'group'
DEPARTMENTSTAFF = 'departmentstaff'
EQUIPMENT = 'equipment'
GEOGRAPHY = 'geography'
GROUPMEMBERSHIP = 'groupmembership'
OCCUPATION = 'occupation'
OFFICE = 'office'
ORGANIZATION = 'organization'
POSITION = 'position'
ROOM = 'room'
TABLE = 'table'

RESOURCE_PLURAL = {
    DEPARTMENTSTAFF: 'departmentstaff',
    EQUIPMENT: 'equipment',
    GEOGRAPHY: 'geographies',
    GROUP: 'groups',
    GROUPMEMBERSHIP: 'groupmembership',
    OCCUPATION: 'occupations',
    OFFICE: 'offices',
    ORGANIZATION: 'organizations',
    PERSON: 'persons',
    POSITION: 'positions',
    ROOM: 'rooms',
    TABLE: 'tables',
}


SENSITIVE_FIELDS = {r: set() for r in RESOURCE_PLURAL}
SENSITIVE_FIELDS[PERSON] = {
    'groups',
    'images',
    'yandex',
    'accounts.value',
    'accounts.value_lower',
    'contacts.value',
    'emails.address',
    'personal.address',
    'personal_emails.value',
    'personal_emails.value_lower',
    'phones.number',
    'skype_accounts.value',
    'skype_accounts.value_lower',
    'telegram_accounts.value',
    'telegram_accounts.value_lower',
}

SENSITIVE_FOR_ROBOTS_FIELDS = {r: set(f) for r, f in SENSITIVE_FIELDS.items()}
SENSITIVE_FOR_ROBOTS_FIELDS[PERSON] |= {
    'location',
    'login',
    'name',
    'robot_owners',
    'robot_users',
    'work_email',
    'work_phone',
}
SENSITIVE_FOR_ROBOTS_FIELDS[GROUP] |= {'ancestors', 'department', 'parent'}
SENSITIVE_FOR_ROBOTS_FIELDS[GROUPMEMBERSHIP] |= {'group', 'person'}
SENSITIVE_FOR_ROBOTS_FIELDS[EQUIPMENT] |= {'hostname'}
SENSITIVE_FOR_ROBOTS_FIELDS[DEPARTMENTSTAFF] |= {'department_group', 'person'}


def validate_role_type(role_type):
    if role_type != 'resource_access':
        raise AccessDenied('Для этого типа ролей workflow не определён')


def validate_resource(resource):
    if resource not in RESOURCE_PLURAL:
        raise AccessDenied(
            '%s — новый ресурс. Напишите в поддержку Стаффа, '
            'что нужно обновить workflow staff-api' % resource
        )


def parse_url(url):
    url = url.strip()
    parsed = urlparse(url)
    params = parse_qs(parsed.query)
    return parsed.path, params

def get_staffapi_fields(url_params_dict):
    filter_fields = set(f for f in url_params_dict if not f.startswith('_'))
    fields = set(url_params_dict.get('_fields', [''])[0].split(','))
    order = set(url_params_dict.get('_sort', [''])[0].split(','))

    query_parts = url_params_dict.get('_query', [''])[0].split(' ')
    query = set()
    query_pattern = re.compile(r'^([\w\.]+)[=<>].+')
    for part in query_parts:
        match = query_pattern.match(part)
        if match:
            query.add(match.groups()[0])

    return set(filter(None, filter_fields | fields | order | query))

def validate_access_url(access_url, resource):
    if not access_url:
        raise AccessDenied('Ссылка — обязательное поле')
    path, params = parse_url(access_url)

    if resource not in path and RESOURCE_PLURAL[resource] not in path:
        raise AccessDenied('Ссылка должна быть на запрашиваемый ресурс')

    if '_fields' not in params:
        raise AccessDenied(
            'Ссылка должна содержать параметр _fields с перечислением полей, '
            'доступ к которым запрашивается'
        )

    requested_access_fields = set(params['_fields'][0].split(','))
    if '_all' in requested_access_fields:
        raise AccessDenied(
            'Если нужен доступ ко всем полям, запросите полный доступ к ресурсу'
        )

def fields_intersects(set1, set2):
    """
    Есть ли пересечения в полях из двух наборов c с учётом иерархии полей
    """
    if set1 & set2:
        return True
    for f1, f2 in itertools.product(set1, set2):
        if f1.startswith(f2) or f2.startswith(f1):
            return True
    return False

def is_safe_to_approve_partial_access(user, resource, access_url):
    if resource not in SENSITIVE_FIELDS:
        return False
    if user.works_in_dep('ext') or user.works_in_dep('outstaff'):
        return False

    sensitive = SENSITIVE_FOR_ROBOTS_FIELDS if user.is_robot else SENSITIVE_FIELDS
    sensitive_fields_set = set(sensitive[resource])

    path, params = parse_url(access_url)
    if '_fields' not in params:
        return False

    requested_fields_set = get_staffapi_fields(params)
    if not fields_intersects(requested_fields_set, sensitive_fields_set):
        return True

    return False

############

resource = role.get('resource')
access_type = role.get('access_type')

validate_role_type(role.get('role_type'))
validate_resource(resource)
approvers = any_from(groupify(147719).members)  # sib

if access_type == 'partial_access':
    access_url = fields_data.get('access_url', '') if fields_data else ''
    validate_access_url(access_url, resource)
    if is_safe_to_approve_partial_access(user, resource, access_url):
        approvers = []


# Дублируем роль в staffapi-test
staffapi_test_role = {
    'system': 'staffapi-test',
    'role_data': role,
}
if fields_data:
    staffapi_test_role.update(role_fields=fields_data)
ref_roles = [staffapi_test_role]
