# coding: utf-8
from __future__ import unicode_literals

import logging

from static_api.listeners import register, BaseListener

from staff_api.v3_0.dehydrators.geography import GeographyPatchDehydrator

logger = logging.getLogger(__name__)


@register('departments.geography')
class GeographyPatchListener(BaseListener):
    def on_modify(self, model, ns):
        department_instance_id = model.get('department_instance')

        if department_instance_id is not None:
            ref_data = model.as_dict(GeographyPatchDehydrator)
            ns.geography.put({'id': department_instance_id}, data=ref_data)
        else:
            logger.info('No department defined for geography %s', model)

    def on_delete(self, model, ns):
        pass
