# coding: utf-8
from __future__ import unicode_literals

import logging

from static_api.listeners import register, BaseListener

from .. import models, dehydrators

log = logging.getLogger(__name__)


@register('oebs.occupation')
class OccupationListener(BaseListener):
    model_class = models.occupation.OccupationModel
    delete_on_zero_intranet_status = False

    def on_modify(self, model, ns):
        ns.occupation.put(
            {'id': model.id},
            data=model.as_dict(dehydrators.occupation.OccupationDehydrator),
        )

    def on_delete(self, model, ns):
        ns.occupation.delete({'id': model.id})
