# coding: utf-8
from __future__ import unicode_literals

import logging

from static_api.listeners import register, BaseListener

from .. import models, dehydrators

log = logging.getLogger(__name__)


@register('oebs.job')
class PositionListener(BaseListener):
    model_class = models.position.PositionModel
    delete_on_zero_intranet_status = False

    def on_modify(self, model, ns):
        ns.position.put(
            {'id': model.id},
            data=model.as_dict(dehydrators.position.PositionDehydrator),
        )

    def on_delete(self, model, ns):
        ns.position.delete({'id': model.id})
