# coding: utf-8
from __future__ import unicode_literals

import os
import json
from optparse import make_option

import dpath.util

from django.core.management.base import BaseCommand
from django.conf import settings
from django.db.models.loading import get_app_path

from static_api.helpers import get_entity_data


class Command(BaseCommand):
    help = 'Dumps row emission data for tests'
    args = '[<model>, ...]'

    option_list = BaseCommand.option_list + (
        make_option('--creation-time',
            action='store',
            default='2013-06-04 18:13:46',
            help='Creation time value for stub message'),
    )

    def handle(self, *selected_entities, **options):
        for entity, (path, values) in settings.API_STUBS_FILTER.items():
            if selected_entities and entity not in selected_entities:
                continue

            print 'Dumping `%s`...' % entity

            result = []

            for chunk in get_entity_data(entity):
                for row in json.loads(chunk['data']):
                    for _, value in dpath.util.search(row, path, yielded=True, separator='.'):
                        if value in values:
                            result.append(row)

            print '\tdone %s rows' % len(result)

            dst_path = os.path.join(get_app_path('v3_0'),
                                    'tests/stub',
                                    '%s.json' % entity)

            with open(dst_path, 'w') as outp:
                json.dump({'id': 0,
                           'action': 'modify',
                           'creation_time': options['creation_time'],
                           'data': json.dumps(result)}, outp, sort_keys=True)
