# coding: utf-8
from __future__ import unicode_literals

from static_api import resources

from . import fields, resources_indexes_hint


class StaffResource(resources.Resource):
    @property
    def doc_tpl_location(self):
        return 'api/docs/' + self.name + '.html'


resources.registry.register(
    StaffResource(
        name='person',
        verbose='Persons (Employees)',
        fieldset_cls=fields.PersonFieldset,
        list_order=0,
        indexes_hint=resources_indexes_hint.persons_indexes_hint,
        ignore_fields={'is_deleted'},
    ),
    StaffResource(
        name='group',
        fieldset_cls=fields.GroupFieldset,
        list_order=1,
        default_filters={'is_deleted': False},
    ),
    StaffResource(
        name='groupmembership',
        plural='groupmembership',
        verbose='Group Membership',
        fieldset_cls=fields.GroupmembershipFieldset,
        list_order=2,
        ignore_fields={'person.is_deleted'},
    ),
    StaffResource(
        name='organization',
        fieldset_cls=fields.OrganizationFieldset,
        list_order=3,
        default_filters={'is_deleted': False},
    ),
    StaffResource(
        name='office',
        fieldset_cls=fields.OfficeFieldset,
        list_order=4,
        default_filters={'is_deleted': False},
    ),
    StaffResource(
        name='table',
        fieldset_cls=fields.TableFieldset,
        list_order=5,
    ),
    StaffResource(
        name='room',
        fieldset_cls=fields.RoomFieldset,
        list_order=6,
        default_filters={'is_deleted': False},
    ),
    StaffResource(
        name='equipment',
        plural='equipment',
        verbose='Office equipment',
        fieldset_cls=fields.EquipmentFieldset,
        list_order=7,
        default_filters={'is_deleted': False},
    ),
    StaffResource(
        name='departmentstaff',
        plural='departmentstaff',
        verbose='Department roles',
        fieldset_cls=fields.DepartmentStaff,
        list_order=8,
    ),
    StaffResource(
        name='position',
        plural='positions',
        verbose='Personnel positions',
        fieldset_cls=fields.PositionFieldset,
        list_order=9,
    ),
    StaffResource(
        name='occupation',
        plural='occupations',
        verbose='Personnel occupations',
        fieldset_cls=fields.OccupationFieldset,
        list_order=10,
    ),
    StaffResource(
        name='geography',
        plural='geographies',
        verbose='Geography',
        fieldset_cls=fields.GeographyFieldset,
        list_order=11,
        default_filters={'is_deleted': False},
    ),
)
