# coding: utf-8
from __future__ import unicode_literals

import logging


log = logging.getLogger(__name__)


def has_shape_in_subquery(shape, query):
    for subquery in query:
        if match_query_shape(shape, subquery):
            return True

    return False


def match_lists_of_subshapes(subshapes, query):
    if not isinstance(query, list):
        return False

    for shape in subshapes:
        if not has_shape_in_subquery(shape, query):
            return False

    return True


def match_query_shape(shape, query):
    for key in shape:
        if key not in query:
            return False

        if key == '$or' or key == '$key':
            if not match_lists_of_subshapes(shape[key], query[key]):
                return False

    return True


def matches_login(query):
    shape = {'login': {}}
    return match_query_shape(shape, query)


def matches_dismissed_and_id(query):
    shape = {
        'id': {},
        'official.is_dismissed': {},
    }

    return match_query_shape(shape, query)


def asks_for_keys(query):
    shape = {
        '$and': [
            {'keys.id': {}},
            {'id': {}},
        ],
        'official.is_dismissed': {},
    }

    return match_query_shape(shape, query)


def persons_indexes_hint(lookup, sort):
    # type: (dict, list) -> unicode
    sort_is_default = not sort or sort == ['id']

    if sort_is_default:
        log.debug('Sort is default')

        # optimization for robot-passport-test that downloads keys
        if asks_for_keys(lookup):
            return 'official.is_dismissed_1_id_1_keys.id_1'

        # Support for queries that loads all persons page by page
        if matches_dismissed_and_id(lookup):
            return 'official.is_dismissed_1_id_1'

        # Support for queries that contains login
        if matches_login(lookup):
            return 'login_1_id_1'

    return None
