# coding: utf-8

from static_api.schema import Schema, SCHEMAS


class StaffSchema(Schema):
    def _get_static_filename(self):
        return 'v3/api/schemas/{}.json'.format(self.id)


SCHEMAS.register(
    StaffSchema('person'),
    StaffSchema('group'),
    StaffSchema('groupmembership'),
    StaffSchema('office'),
    StaffSchema('organization'),
    StaffSchema('table'),
    StaffSchema('equipment'),
    StaffSchema('room'),
    StaffSchema('departmentstaff'),
    StaffSchema('common'),
    StaffSchema('position'),
    StaffSchema('occupation'),
    StaffSchema('geography'),
)
