# coding: utf-8
from __future__ import absolute_import

from static_api import storage, tasks


def run_init(entity=None, reset=False, meta=False):
    storage.manager.get_state_manager().set_state('init')

    if reset:
        tasks.reset.apply_async(
            kwargs={'include_meta': meta},
            link=tasks.init.si(entity=entity)
        )
    else:
        tasks.init.delay(entity=entity)


def run_ensure_indexes():
    tasks.ensure_indexes.delay()


def run_compact():
    tasks.compact.delay()
