# coding: utf-8
from __future__ import unicode_literals

import dpath.util


class Dehydrator(object):
    fields = []

    def __init__(self, data):
        self.data = data

    def get_raw(self, key):
        data = self.data

        bits = key.split('.')

        for bit in bits:
            try:
                data = data[bit]
            except KeyError:
                return {}

        def _merge(host, bit):
            top = host[bit] = {}

            return top

        result = {}
        top = reduce(_merge, bits[:-1], result)
        top[bits[-1]] = data

        return result

    def get(self, name):
        if hasattr(self, 'get_%s' % name):
            value = {name: getattr(self, 'get_%s' % name)()}
        else:
            value = self.get_raw(name)

        return value

    def as_dict(self):
        res = {}

        for key in list(self.fields):
            val = self.get(key)

            dpath.util.merge(res, val)

        return res
