# coding: utf-8
from __future__ import unicode_literals

import logging

from static_api import models, client


log = logging.getLogger(__name__)

registry = client.Registry()


def register(entity):
    def _wrapper(cls):
        registry.add_listener(entity, cls)

        return cls

    return _wrapper


class ModelMixin(object):
    model_class = models.Model

    def _create_model(self, event, namespace):
        return self.model_class(event, namespace)

    def dispatch(self, event, namespace):
        model = self._create_model(event, namespace)

        return super(ModelMixin, self).dispatch(model, namespace)


class ContextMixin(object):
    def dispatch(self, model, namespace):
        data = {
            '_meta': dict(
                (k, v) for k, v in model._meta.items()
                if k in ('modified_at', 'message_id')
            )
        }

        with namespace.context(data):
            return super(ContextMixin, self).dispatch(model, namespace)


class IntranetStatusMixin(object):
    delete_on_zero_intranet_status = True

    def dispatch(self, model, namespace):
        action = model.event.get_action()

        if action == 'delete' or (self.delete_on_zero_intranet_status
                                  and model.get('intranet_status') == 0):
            self.on_delete(model, namespace)

            return True
        elif action == 'modify':
            self.on_modify(model, namespace)

            return True

        return False


class BaseListener(
    ModelMixin,
    ContextMixin,
    IntranetStatusMixin,
    client.Listener):
    pass
